//
//  TransactionStore.m
//  ABC Bank
//
//  Created by oliviers on 10/13/13.
//  Copyright (c) 2013 Cisco Systems, Inc. All rights reserved.
//

#import "TransactionStore.h"
#import "Transaction.h"

@interface TransactionStore () {
    NSMutableArray * allItems;
}

- (Transaction*)createItem:(int)rand;

@end

@implementation TransactionStore

@synthesize name, balance, accountNumber;

- (id)initWithName:(NSString *)storeName balance:(NSDecimalNumber *)storeBalance number:(NSUInteger)number index:(NSUInteger)index
{
    self = [super init];
    if(self){
        allItems = [[NSMutableArray alloc]init];
        
        name = storeName;
        balance = storeBalance;
        accountNumber = [NSString stringWithFormat:@"%06u-%03u", number, index];
        
        for ( int i = 0; i < 25; ++i )
        {
            [self createItem:arc4random()];
        }
    }
    return self;
}

- (NSArray*)allItems
{
    return allItems;
}

- (Transaction*)createItem:(int)rand
{
    Transaction* p = [Transaction randomItem:rand];
    [allItems addObject:p];
    return p;
}
@end
